/************************************************************/
/* PROJECT NAME: FIR	                                    */
/* Project:      LPC2100 Training course                    */
/* Engineer:     T Martin                                   */
/* Filename:     main.c                                     */
/* Language:     C                      	                */
/* Compiler:     GCC ARM port			                    */
/* Assembler:    As  ARM port	                            */
/*                                                          */
/************************************************************/
/* Modification History:                                    */
/*                                                          */
/************************************************************/
/* Function:                                                */
/*                                                          */
/* Example Interrupt program for LPC2100           			*/
/*															*/
/* Demonstrates configuring a function as an ISR			*/
/*															*/	
/* Oscillator frequency 12.000 Mhz							*/
/* Target board Keil MCB2100								*/
/************************************************************/


#include <LPC21xx.H>
void EXTintFIQ (void) ;	   //declare FIQ ISR
void initFiq (void);

int main (void)
{

initFiq();											   //Initilise the Fast interrupt source

while(1)
{
IOCLR1 = 0x00FF0000;								  //Loop here forever
}

}

void EXTintFIQ (void)
{
IOSET1 	= 0x00FF0000;								//Set the LED pins
EXTINT  = 0x00000002;								//Clear the peripheral interrupt flag

}

void initFiq(void)
{
IODIR1			= 0x00FF0000;							//Set the LED pins as outputs
PINSEL0 		= 0x20000000;							//Enable the EXTINT1 interrupt
VICIntSelect 	= 0x00008000;							//Enable a Vic Channel as FIQ
VICIntEnable	= 0x00008000;		
}
